/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1993  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/
/*

LIBRARY        : alteralib; Rev 1.0; February 93
FUNCTION       : PRESETTABLE SYNCHRONOUS  BCD DECADE COUNTER 
TRUTHTABLE     : 
+---------------------------------------+-----------------------+
|              INPUT                    |                       |
+---------------------------------------+       OPERATION       |
|     CLR_    LOAD_  ENT   ENP    CLK   |                       |
+---------------------------------------+-----------------------+
|      L        X     X     X      X    |   Synchronous Clear   | 
|                                   _   |                       |
|      H        L     X     X     _/    |   Load Parrallel Data |
|                                   _   |                       |
|      H        H     H     H     _/    |   Decade Counter      |
|                                       |                       |
|      H        H     L     X      X    |   Inhibit Counting    |
|                                       |                       |
|      H        H     X     L      X    |   Inhibit Counting    |
+---------------------------------------+-----------------------+

Note = TC goes high at the terminal count for the duration
       of one clock pulse.

REFERENCE      : Altera MAX+Plus II online help, component description
DESIGNER       : AMI VIDER
DATE GENERATED : February 1993
DATE MODIFIED  : August 1993

VERITOOL COMPATIBILITY : Verilog x.x, Veritime y.y

*/
`celldefine

`timescale  1ns /  100ps
module a162 (clrn, clk, a, b, c, d, enp, ldn, ent, qd, qc, qb, qa, rco);
	parameter size =1;
	parameter cds_action = "ignore";
	input
		clrn,
		clk,
		a,
		b,
		c,
		d,
		enp,
		ldn,
		ent;
	output
		qd,
		qc,
		qb,
		qa,
		rco;
    reg
        NOTIFY_REG;
    not
	N1 (load, ldn);
    and
	A1 (en1, load, clrn);
    and
	A2 (en2, ldn, clrn);
    and
	A3 (en3, en2, ent);
    and
	A4 (en4, en2, enp);
    not
	M162_inst_I1 (m162_inst_wi1, ldn);
    and
	M162_inst_A1 (m162_inst_wa1, enp, ent, ldn);
    and  
	M162_inst_A2 (rco, dd_net_43, m162_inst_qaint, m162_inst_qdint);
    and
	M162_inst_A3 (m162_inst_wa3, ldn, m162_inst_qaint);
    and
	M162_inst_A7 (m162_inst_wa7, m162_inst_wna1, ldn, m162_inst_qbint);
    and
	M162_inst_A8 (m162_inst_wa8, m162_inst_wna2, m162_inst_wa1, m162_inst_qaint, m162_inst_wqbint4);
    and
	M162_inst_A9 (m162_inst_wa9, m162_inst_wi1, b);
    and
	M162_inst_A11 (m162_inst_wa11, m162_inst_wna3, ldn, m162_inst_qdint);
    and
	M162_inst_A12 (m162_inst_wa12, m162_inst_wna4, m162_inst_wa1, m162_inst_qcint, m162_inst_qbint, m162_inst_qaint);
    and
	M162_inst_A13 (m162_inst_wa13, m162_inst_wi1, d);
    and
	M162_inst_A14 (m162_inst_wa14, m162_inst_wo1, clrn);
    and
	M162_inst_A15 (m162_inst_wa15, m162_inst_wo2, clrn);
    and
	M162_inst_A16 (m162_inst_wa16, m162_inst_wo3, clrn);
    and
	M162_inst_A17 (m162_inst_wa17, m162_inst_wo4, clrn);
    nand
	M162_inst_NA1 (m162_inst_wna1, m162_inst_wa1, m162_inst_qaint);
    nand
	M162_inst_NA2 (m162_inst_wna2, ldn, m162_inst_qbint);
    nand
	M162_inst_NA3 (m162_inst_wna3, m162_inst_wa1, m162_inst_qaint);
    nand
	M162_inst_NA4 (m162_inst_wna4, ldn, m162_inst_qdint);
    xor
	M162_inst_XO1 (m162_inst_wxo1, m162_inst_wa3, m162_inst_wa1);
    or
	M162_inst_O2 (m162_inst_wo2, m162_inst_wa7, m162_inst_wa8, m162_inst_wa9);
    or
	M162_inst_O4 (m162_inst_wo4, m162_inst_wa11, m162_inst_wa12, m162_inst_wa13);
    not
	M162_inst_N1 (m162_inst_wqbint4, m162_inst_qdint);
    buf  
	  (qa, m162_inst_qaint);
    buf
	  (qb, m162_inst_qbint);
    buf  
	  (qc, m162_inst_qcint);
    buf  
	  (qd, m162_inst_qdint);
    U_AO_3
	M162_inst_inst1_inst1 (m162_inst_wo1, m162_inst_wxo1, m162_inst_wi1, a);
    U_AXO_2_3
	M162_inst_inst2_inst1 (m162_inst_wxo2, ldn, m162_inst_qcint, m162_inst_wa1, m162_inst_qaint, m162_inst_qbint);
    U_AO_3
	M162_inst_inst3_inst1 (m162_inst_wo3, m162_inst_wxo2, m162_inst_wi1, c);
    U_FD_P_NO  
	M162_inst_DFF1_inst1 (m162_inst_qaint, m162_inst_wa14, clk, NOTIFY_REG);
    U_FD_P_NO 
	M162_inst_DFF2_inst1 (m162_inst_qbint, m162_inst_wa15, clk, NOTIFY_REG);
    U_FD_P_NO
	M162_inst_DFF3_inst1 (m162_inst_qcint, m162_inst_wa16, clk, NOTIFY_REG);
    U_FD_P_NO  
	M162_inst_DFF4_inst1 (m162_inst_qdint, m162_inst_wa17, clk, NOTIFY_REG);
    buf  
	  (dd_net_43, ent);

    specify

	// Synthesis parameters

`ifdef SYNTH
	specparam Area = 1;
`endif



    endspecify

endmodule
`endcelldefine
